# Image Upload Instructions for Hotili Hotel

## Quick Start

Your hotel website is now ready for real images! Follow these simple steps:

### Where to Add Images

1. **Room Images** → Place in: `public/images/rooms/`
2. **Amenity Images** → Place in: `public/images/`

### Step-by-Step Guide

#### 1. Add Room Images

Each room type should have its own image. The system automatically finds images by room slug or ID.

**Example:**
- If you have a "Single Room" with ID=1 or slug="single-room"
- Upload image as: `single-room.jpg` OR `1.jpg`
- Location: `public/images/rooms/single-room.jpg`

**Files to Create:**
```
public/images/rooms/
├── single-room.jpg (or 1.jpg)
├── double-room.jpg (or 2.jpg)
├── suite.jpg (or 3.jpg)
└── deluxe-suite.jpg (or 4.jpg)
```

#### 2. Add Amenity Images (Optional - Currently Showing Gradients)

Update the About section with real images:

**Files to Create:**
```
public/images/
├── pool.jpg (Pool & Fitness area - 450x300px)
├── restaurant.jpg (Restaurant & Dining - 300x300px)
├── spa.jpg (Spa & Garden - 300x450px)
└── events.jpg (Event Spaces - 450x300px)
```

#### 3. Image Specifications

| Property | Requirement |
|----------|-------------|
| Format | JPG, PNG, or WebP |
| Room Images | 400x300px minimum (16:9 aspect ratio) |
| Amenity Images | 300-450px on shortest side |
| File Size | < 200KB each (use compression) |
| Quality | High quality (80-90% JPEG quality) |

### How to Upload

#### Using Windows File Manager:
1. Open: `C:\xampp\htdocs\hotili\public\images\`
2. Create `rooms` folder if it doesn't exist
3. Copy/paste your images

#### Using FTP Client (Filezilla, etc.):
1. Connect to your XAMPP local server
2. Navigate to: `/xampp/htdocs/hotili/public/images/`
3. Upload images

#### Using VS Code:
1. Right-click on `public/images/` folder
2. Select "Reveal in File Explorer"
3. Paste your images there

### Image Optimization Tools (Free)

- **TinyPNG**: https://tinypng.com/ (Compress images)
- **ImageOptim**: https://imageoptim.com/ (For Mac)
- **Paint.NET**: https://www.getpaint.net/ (Resize/crop)
- **GIMP**: https://www.gimp.org/ (Free Photoshop alternative)

### Testing

Once you upload images:
1. Refresh the browser at `http://localhost/`
2. Room cards should display real images
3. If not, check filename matches room slug/ID exactly

### Current Placeholders

The website currently uses:
- **Room Cards**: Gradient backgrounds (blue-based)
- **Amenities Section**: Colorful gradients with text overlays

These will be replaced with your real images when uploaded.

### Sample Image Filenames

Match your database exactly:

**If using ID (Numeric):**
```
1.jpg → Room ID 1
2.jpg → Room ID 2
3.jpg → Room ID 3
```

**If using Slug (Text):**
```
single-room.jpg → Room slug "single-room"
double-room.jpg → Room slug "double-room"
luxury-suite.jpg → Room slug "luxury-suite"
```

### Need Help?

1. Check the database room IDs: Admin Panel → Rooms
2. Database slugs: In app/Models/RoomType.php (or run migration)
3. Verify image paths in: resources/js/Pages/Welcome.vue

### Future: Add Image Upload to Admin

To allow staff to upload images from the admin panel:
1. Add media field to RoomType Filament resource
2. Use Filament's built-in FileUpload
3. Configure storage in config/filesystems.php

### Images you might use:
- **Unsplash**: https://unsplash.com/ (Free quality photos)
- **Pexels**: https://www.pexels.com/ (Free stock photos)
- **Pixabay**: https://pixabay.com/ (Free images)

Search for:
- "Hotel room"
- "Luxury bedroom"
- "Swimming pool"
- "Restaurant"
- "Spa"
- "Event venue"

---

**Current Status**: ✅ Website structure ready | ⏳ Waiting for images

Once you add images, your hotel website will look like a professional 5-star resort!
