<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class UserManagementController extends Controller
{
    public function index(): Response
    {
        return Inertia::render('Admin/Users', [
            'users' => User::query()
                ->select('id', 'name', 'email', 'role', 'created_at')
                ->orderBy('name')
                ->get(),
            'roles' => [
                User::ROLE_ADMIN,
                User::ROLE_RECEPTION,
            ],
        ]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', 'max:255', 'unique:users,email'],
            'role' => ['required', 'in:' . implode(',', [User::ROLE_ADMIN, User::ROLE_RECEPTION])],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        User::create($validated);

        return back()->with('success', 'User created successfully.');
    }

    public function update(Request $request, User $user)
    {
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'role' => ['required', 'in:' . implode(',', [User::ROLE_ADMIN, User::ROLE_RECEPTION])],
        ]);

        $user->update($validated);

        return back()->with('success', 'User updated successfully.');
    }
}
