<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\RoomType;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Storage;

class RoomTypeController extends Controller
{
    public function index(): JsonResponse
    {
        $roomTypes = RoomType::query()
            ->withCount('rooms')
            ->orderBy('base_price')
            ->get()
            ->map(function (RoomType $roomType) {
                $slugOrId = $roomType->slug ?: $roomType->id;

                return [
                    'id' => $roomType->id,
                    'name' => $roomType->name,
                    'description' => $roomType->description,
                    'base_price' => $roomType->base_price,
                    'capacity' => $roomType->capacity,
                    'area' => $roomType->area,
                    'amenities' => $roomType->amenities ?? [],
                    'rooms_count' => $roomType->rooms_count,
                    'image_url' => $roomType->image_path
                        ? Storage::url($roomType->image_path)
                        : url("/images/{$slugOrId}.jpg"),
                ];
            });

        return response()->json($roomTypes);
    }
}
