import { Link } from "react-router-dom";
import { Button } from "@/components/ui/button";
import restaurantImage from "@/assets/restaurant.jpg";

export function AboutPreview() {
  return (
    <section className="py-20 bg-primary overflow-hidden">
      <div className="container mx-auto px-4 lg:px-8">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          {/* Image */}
          <div className="relative">
            <div className="relative rounded-xl overflow-hidden shadow-elevated">
              <img
                src={restaurantImage}
                alt="Hotili Restaurant"
                className="w-full h-[400px] lg:h-[500px] object-cover"
              />
              <div className="absolute inset-0 bg-gradient-to-r from-primary/30 to-transparent" />
            </div>
            {/* Decorative Elements */}
            <div className="absolute -bottom-6 -right-6 w-32 h-32 border-2 border-gold/30 rounded-xl -z-10" />
            <div className="absolute -top-6 -left-6 w-24 h-24 bg-gold/10 rounded-xl -z-10" />
          </div>

          {/* Content */}
          <div className="lg:pl-8">
            <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
              Our Story
            </span>
            <h2 className="text-3xl md:text-4xl font-serif font-bold text-primary-foreground mt-3 mb-6">
              A Legacy of Hospitality
            </h2>
            <div className="h-1 w-16 bg-gradient-gold mb-6" />
            <p className="text-primary-foreground/80 leading-relaxed mb-6">
              Hotili is designed for guests who value comfort, style, and personalized 
              service. We blend modern African hospitality with world-class standards 
              to create memorable experiences.
            </p>
            <p className="text-primary-foreground/80 leading-relaxed mb-8">
              From our elegantly appointed rooms to our exceptional dining experiences, 
              every detail is crafted with care to ensure your stay exceeds expectations.
            </p>
            <div className="flex flex-wrap gap-6 mb-8">
              <div className="text-center">
                <div className="text-4xl font-serif font-bold text-gold">15+</div>
                <div className="text-primary-foreground/70 text-sm">Years of Excellence</div>
              </div>
              <div className="w-px bg-gold/30" />
              <div className="text-center">
                <div className="text-4xl font-serif font-bold text-gold">50K+</div>
                <div className="text-primary-foreground/70 text-sm">Happy Guests</div>
              </div>
              <div className="w-px bg-gold/30" />
              <div className="text-center">
                <div className="text-4xl font-serif font-bold text-gold">4.9</div>
                <div className="text-primary-foreground/70 text-sm">Guest Rating</div>
              </div>
            </div>
            <Link to="/about">
              <Button variant="goldOutline">
                Learn More About Us
              </Button>
            </Link>
          </div>
        </div>
      </div>
    </section>
  );
}
