import { useState } from "react";
import { CalendarDays, Users, ChevronDown } from "lucide-react";
import { Button } from "@/components/ui/button";

export function BookingWidget() {
  const [checkIn, setCheckIn] = useState("");
  const [checkOut, setCheckOut] = useState("");
  const [roomType, setRoomType] = useState("deluxe");

  return (
    <section className="relative z-20 -mt-24 pb-20">
      <div className="container mx-auto px-4 lg:px-8">
        <div className="bg-card rounded-2xl shadow-elevated p-6 lg:p-8 gold-border">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
            {/* Check-in Date */}
            <div className="lg:col-span-1">
              <label className="block text-sm font-medium text-muted-foreground mb-2">
                Check-in Date
              </label>
              <div className="relative">
                <CalendarDays className="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gold" />
                <input
                  type="date"
                  value={checkIn}
                  onChange={(e) => setCheckIn(e.target.value)}
                  className="w-full bg-background border border-border rounded-lg pl-11 pr-4 py-3 text-foreground focus:outline-none focus:ring-2 focus:ring-gold/50 focus:border-gold transition-all"
                />
              </div>
            </div>

            {/* Check-out Date */}
            <div className="lg:col-span-1">
              <label className="block text-sm font-medium text-muted-foreground mb-2">
                Check-out Date
              </label>
              <div className="relative">
                <CalendarDays className="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gold" />
                <input
                  type="date"
                  value={checkOut}
                  onChange={(e) => setCheckOut(e.target.value)}
                  className="w-full bg-background border border-border rounded-lg pl-11 pr-4 py-3 text-foreground focus:outline-none focus:ring-2 focus:ring-gold/50 focus:border-gold transition-all"
                />
              </div>
            </div>

            {/* Room Type */}
            <div className="lg:col-span-1">
              <label className="block text-sm font-medium text-muted-foreground mb-2">
                Room Type
              </label>
              <div className="relative">
                <Users className="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gold" />
                <select
                  value={roomType}
                  onChange={(e) => setRoomType(e.target.value)}
                  className="w-full bg-background border border-border rounded-lg pl-11 pr-10 py-3 text-foreground appearance-none focus:outline-none focus:ring-2 focus:ring-gold/50 focus:border-gold transition-all"
                >
                  <option value="deluxe">Deluxe Room</option>
                  <option value="executive">Executive Suite</option>
                  <option value="presidential">Presidential Suite</option>
                </select>
                <ChevronDown className="absolute right-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground pointer-events-none" />
              </div>
            </div>

            {/* Guests */}
            <div className="lg:col-span-1">
              <label className="block text-sm font-medium text-muted-foreground mb-2">
                Guests
              </label>
              <div className="relative">
                <Users className="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gold" />
                <select
                  className="w-full bg-background border border-border rounded-lg pl-11 pr-10 py-3 text-foreground appearance-none focus:outline-none focus:ring-2 focus:ring-gold/50 focus:border-gold transition-all"
                >
                  <option value="1">1 Guest</option>
                  <option value="2">2 Guests</option>
                  <option value="3">3 Guests</option>
                  <option value="4">4 Guests</option>
                </select>
                <ChevronDown className="absolute right-3 top-1/2 -translate-y-1/2 w-5 h-5 text-muted-foreground pointer-events-none" />
              </div>
            </div>

            {/* Book Now Button */}
            <div className="lg:col-span-1 flex items-end">
              <Button variant="gold" className="w-full py-3 h-[50px]">
                Check Availability
              </Button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
