import { useQuery } from "@tanstack/react-query";

export type RoomTypeDto = {
  id: number;
  name: string;
  description: string | null;
  base_price: number | string;
  capacity: number | null;
  area: number | null;
  amenities: string[];
  rooms_count: number;
  image_url?: string;
};

const getApiBaseUrl = () => {
  const base = import.meta.env.VITE_API_BASE_URL || "http://localhost/Hotili";
  return base.replace(/\/+$/, "");
};

const fetchRoomTypes = async (): Promise<RoomTypeDto[]> => {
  const response = await fetch(`${getApiBaseUrl()}/api/room-types`);
  if (!response.ok) {
    throw new Error("Failed to load room types");
  }
  return response.json();
};

export const useRoomTypes = () =>
  useQuery({
    queryKey: ["room-types"],
    queryFn: fetchRoomTypes,
  });
