import { Layout } from "@/components/Layout";
import { Button } from "@/components/ui/button";
import heroImage from "@/assets/hero-hotel.jpg";
import restaurantImage from "@/assets/restaurant.jpg";

const About = () => {
  return (
    <Layout>
      {/* Hero Section */}
      <section className="pt-32 pb-16 bg-primary">
        <div className="container mx-auto px-4 lg:px-8 text-center">
          <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
            Our Story
          </span>
          <h1 className="text-4xl md:text-5xl font-serif font-bold text-primary-foreground mt-3 mb-4">
            About Hotili
          </h1>
          <div className="gold-divider mx-auto" />
          <p className="text-primary-foreground/80 mt-6 max-w-2xl mx-auto">
            A legacy of hospitality, comfort, and excellence since 2010.
          </p>
        </div>
      </section>

      {/* Story Section */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div>
              <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
                Welcome to Hotili
              </span>
              <h2 className="text-3xl md:text-4xl font-serif font-bold text-foreground mt-3 mb-6">
                Where Luxury Meets Warmth
              </h2>
              <div className="h-1 w-16 bg-gradient-gold mb-6" />
              <p className="text-muted-foreground leading-relaxed mb-6">
                Hotili is designed for guests who value comfort, style, and personalized 
                service. Nestled in the heart of the city, our hotel represents the perfect 
                fusion of modern luxury and warm African hospitality.
              </p>
              <p className="text-muted-foreground leading-relaxed mb-6">
                Every corner of Hotili tells a story of meticulous attention to detail, 
                from our elegantly appointed rooms to our world-class dining experiences. 
                We believe that true luxury lies not just in opulent surroundings, but in 
                the warmth of genuine hospitality.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                Our dedicated team of professionals is committed to making every moment 
                of your stay exceptional. Whether you're here for business or leisure, 
                we promise an experience that exceeds your expectations.
              </p>
            </div>
            <div className="relative">
              <img
                src={heroImage}
                alt="Hotili Lobby"
                className="rounded-xl shadow-elevated"
              />
              <div className="absolute -bottom-8 -left-8 w-40 h-40 bg-primary rounded-xl flex flex-col items-center justify-center shadow-card">
                <span className="text-gold font-serif text-4xl font-bold">15+</span>
                <span className="text-primary-foreground text-sm">Years of Excellence</span>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="py-20 bg-muted">
        <div className="container mx-auto px-4 lg:px-8">
          <div className="text-center mb-16">
            <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
              Our Philosophy
            </span>
            <h2 className="text-3xl md:text-4xl font-serif font-bold text-foreground mt-3 mb-4">
              What We Stand For
            </h2>
            <div className="gold-divider mx-auto" />
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="text-center p-8">
              <div className="text-5xl mb-6">🏆</div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                Excellence
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                We strive for excellence in everything we do, from the quality of our 
                amenities to the warmth of our service.
              </p>
            </div>
            <div className="text-center p-8">
              <div className="text-5xl mb-6">❤️</div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                Hospitality
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                True hospitality comes from the heart. We treat every guest like family, 
                ensuring you feel at home.
              </p>
            </div>
            <div className="text-center p-8">
              <div className="text-5xl mb-6">✨</div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                Innovation
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                We continuously evolve, embracing modern technology and design while 
                honoring timeless traditions.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Team Section */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div className="order-2 lg:order-1">
              <img
                src={restaurantImage}
                alt="Hotili Team"
                className="rounded-xl shadow-elevated"
              />
            </div>
            <div className="order-1 lg:order-2">
              <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
                Our Team
              </span>
              <h2 className="text-3xl md:text-4xl font-serif font-bold text-foreground mt-3 mb-6">
                The Heart of Hotili
              </h2>
              <div className="h-1 w-16 bg-gradient-gold mb-6" />
              <p className="text-muted-foreground leading-relaxed mb-6">
                Behind every exceptional experience at Hotili is a dedicated team of 
                hospitality professionals who are passionate about creating memorable 
                moments for our guests.
              </p>
              <p className="text-muted-foreground leading-relaxed mb-8">
                From our skilled chefs crafting culinary delights to our attentive 
                housekeeping staff ensuring pristine comfort, every team member plays 
                a vital role in the Hotili experience.
              </p>
              <Button variant="gold" size="lg">
                Join Our Team
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-16 bg-primary">
        <div className="container mx-auto px-4 lg:px-8">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            <div>
              <div className="text-4xl md:text-5xl font-serif font-bold text-gold mb-2">150+</div>
              <div className="text-primary-foreground/80 text-sm">Rooms & Suites</div>
            </div>
            <div>
              <div className="text-4xl md:text-5xl font-serif font-bold text-gold mb-2">50K+</div>
              <div className="text-primary-foreground/80 text-sm">Happy Guests</div>
            </div>
            <div>
              <div className="text-4xl md:text-5xl font-serif font-bold text-gold mb-2">200+</div>
              <div className="text-primary-foreground/80 text-sm">Team Members</div>
            </div>
            <div>
              <div className="text-4xl md:text-5xl font-serif font-bold text-gold mb-2">4.9</div>
              <div className="text-primary-foreground/80 text-sm">Guest Rating</div>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
};

export default About;
