import { Layout } from "@/components/Layout";
import { 
  Clock, 
  Wifi, 
  Utensils, 
  ConciergeBell, 
  Plane, 
  Shirt,
  Car,
  Dumbbell,
  Sparkles,
  Coffee
} from "lucide-react";

const services = [
  {
    icon: Clock,
    title: "24/7 Front Desk",
    description: "Our dedicated staff is available around the clock to assist with any request.",
  },
  {
    icon: Wifi,
    title: "Free High-Speed Wi-Fi",
    description: "Stay connected with complimentary high-speed internet throughout the property.",
  },
  {
    icon: Utensils,
    title: "Restaurant & Bar",
    description: "Savor exquisite cuisine and handcrafted cocktails at our elegant restaurant.",
  },
  {
    icon: ConciergeBell,
    title: "Room Service",
    description: "Enjoy in-room dining with our extensive menu available 24 hours a day.",
  },
  {
    icon: Plane,
    title: "Airport Transfer",
    description: "Complimentary luxury airport pickup and drop-off service for all guests.",
  },
  {
    icon: Shirt,
    title: "Laundry Service",
    description: "Express laundry and dry cleaning with same-day delivery available.",
  },
  {
    icon: Car,
    title: "Valet Parking",
    description: "Secure valet parking with premium care for your vehicle.",
  },
  {
    icon: Dumbbell,
    title: "Fitness Center",
    description: "State-of-the-art gym equipment with personal trainer available on request.",
  },
  {
    icon: Sparkles,
    title: "Spa & Wellness",
    description: "Rejuvenate with our range of spa treatments and wellness programs.",
  },
  {
    icon: Coffee,
    title: "Executive Lounge",
    description: "Exclusive access to our lounge with complimentary refreshments and business facilities.",
  },
];

const Services = () => {
  return (
    <Layout>
      {/* Hero Section */}
      <section className="pt-32 pb-16 bg-primary">
        <div className="container mx-auto px-4 lg:px-8 text-center">
          <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
            What We Offer
          </span>
          <h1 className="text-4xl md:text-5xl font-serif font-bold text-primary-foreground mt-3 mb-4">
            Our Services
          </h1>
          <div className="gold-divider mx-auto" />
          <p className="text-primary-foreground/80 mt-6 max-w-2xl mx-auto">
            Experience exceptional hospitality with our comprehensive range of services 
            designed to make your stay truly memorable.
          </p>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-6">
            {services.map((service, index) => (
              <div
                key={index}
                className="group bg-primary rounded-xl p-6 text-center transition-all duration-500 hover:shadow-elevated hover:-translate-y-2"
              >
                <div className="w-14 h-14 mx-auto mb-4 rounded-full bg-gold/10 flex items-center justify-center group-hover:bg-gold transition-colors duration-500">
                  <service.icon className="w-6 h-6 text-gold group-hover:text-charcoal transition-colors duration-500" />
                </div>
                <h3 className="text-lg font-serif font-semibold text-primary-foreground mb-2">
                  {service.title}
                </h3>
                <p className="text-primary-foreground/70 text-sm leading-relaxed">
                  {service.description}
                </p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Special Services Section */}
      <section className="py-20 bg-muted">
        <div className="container mx-auto px-4 lg:px-8">
          <div className="text-center mb-16">
            <span className="text-gold text-sm tracking-[0.2em] uppercase font-medium">
              Exclusive
            </span>
            <h2 className="text-3xl md:text-4xl font-serif font-bold text-foreground mt-3 mb-4">
              Special Experiences
            </h2>
            <div className="gold-divider mx-auto" />
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="bg-card rounded-xl p-8 shadow-card gold-border text-center">
              <div className="text-4xl mb-4">🎂</div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                Celebrations
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                Make birthdays, anniversaries, and special occasions unforgettable with 
                custom decorations and personalized service.
              </p>
            </div>

            <div className="bg-card rounded-xl p-8 shadow-card gold-border text-center">
              <div className="text-4xl mb-4">💼</div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                Business Facilities
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                State-of-the-art meeting rooms and conference facilities for your 
                corporate events and business needs.
              </p>
            </div>

            <div className="bg-card rounded-xl p-8 shadow-card gold-border text-center">
              <div className="text-4xl mb-4">💒</div>
              <h3 className="text-xl font-serif font-semibold text-foreground mb-3">
                Weddings & Events
              </h3>
              <p className="text-muted-foreground text-sm leading-relaxed">
                Create magical moments with our stunning venues and dedicated 
                event planning team.
              </p>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
};

export default Services;
