# Hotel Images Directory

This folder structure is for storing all hotel-related images for the website.

## Folder Structure

```
images/
├── rooms/          # Room type images
├── amenities/      # Amenities and facilities images
├── events/         # Event space images
├── gallery/        # General gallery images
└── logo.png        # Hotel logo
```

## Room Images

Store room type images in the `rooms/` folder with the following naming convention:

### Naming Convention:
- Use the room slug or ID as the filename
- Format: `{room-slug}.jpg` or `{room-id}.jpg`
- Examples: `single-room.jpg`, `double-room.jpg`, `suite.jpg`, `1.jpg`, `2.jpg`

### Required Images:
1. **Room Images** (for room cards)
   - Dimensions: 400x300px minimum (16:9 aspect ratio)
   - Format: JPG or PNG
   - Quality: High (80-90% compression)
   - Location: `/public/images/rooms/{room-slug}.jpg`

2. **Amenities Images** (currently as gradients but can be replaced)
   - `pool.jpg` - Pool and fitness center
   - `restaurant.jpg` - Restaurant/dining area
   - `spa.jpg` - Spa and garden
   - `events.jpg` - Event and conference spaces
   - Location: `/public/images/{image-name}.jpg`

## How to Add Images

### Option 1: Using File Manager (Recommended)
1. Navigate to `public/images/rooms/` directory
2. Drag and drop your room images
3. The system will automatically display them based on the room ID/slug

### Option 2: Using FTP
1. Connect via FTP to your hosting
2. Upload images to `/public/images/rooms/`
3. Ensure filenames match room slugs exactly

### Option 3: Programmatic Upload (Future Enhancement)
Create an admin interface to upload room images directly from Filament.

## Updating Room Card Images in Code

The RoomCard component looks for images using this path:
```
/images/rooms/{roomType.slug || roomType.id}.jpg
```

Make sure your room model includes a `slug` field or use the numeric `id`.

### Database Migration to Add Slug:
```php
Schema::table('room_types', function (Blueprint $table) {
    $table->string('slug')->nullable()->unique();
});
```

## Image Optimization Tips

- **Compress images** before uploading: Use tools like TinyPNG, ImageOptim, or Sharp
- **Use appropriate formats**: JPG for photos, PNG for graphics with transparency
- **Responsive images**: Consider creating 2x versions for retina displays
- **Lazy loading**: Already implemented in the component

## Current Placeholder Strategy

Until you upload real images:
1. Room cards show gradient backgrounds
2. Amenities section shows colorful gradients
3. Fallback ensures website looks complete

## Next Steps

1. Add room images to `/public/images/rooms/`
2. Add amenity images:
   - `/public/images/pool.jpg`
   - `/public/images/restaurant.jpg`
   - `/public/images/spa.jpg`
   - `/public/images/events.jpg`
3. Update the amenities section in `resources/js/Pages/Welcome.vue` to use actual images

## Modifying Image Paths

To update amenities images in Welcome.vue, replace the gradient divs with:

```vue
<div class="relative h-64 bg-cover rounded-xl overflow-hidden shadow-lg" 
     style="background-image: url('/images/pool.jpg');">
</div>
```

## Contact Support

For help with image optimization or implementation, refer to the hotel system documentation.
