<?php

use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\BookingManagementController;
use App\Http\Controllers\Admin\RoomManagementController;
use App\Http\Controllers\Admin\RoomTypeManagementController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ReceptionDashboardController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::post('/check-availability', [HomeController::class, 'checkAvailability'])->name('check-availability');
Route::post('/book', [HomeController::class, 'createBooking'])->name('book');

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.attempt');
});

Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [AuthController::class, 'redirectToDashboard'])->name('dashboard.redirect');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::prefix('admin')->name('admin.')->middleware('role:admin')->group(function () {
        Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');
        Route::get('/users', [UserManagementController::class, 'index'])->name('users.index');
        Route::post('/users', [UserManagementController::class, 'store'])->name('users.store');
        Route::put('/users/{user}', [UserManagementController::class, 'update'])->name('users.update');

        Route::get('/room-types', [RoomTypeManagementController::class, 'index'])->name('room-types.index');
        Route::post('/room-types', [RoomTypeManagementController::class, 'store'])->name('room-types.store');
        Route::put('/room-types/{roomType}', [RoomTypeManagementController::class, 'update'])->name('room-types.update');

        Route::get('/rooms', [RoomManagementController::class, 'index'])->name('rooms.index');
        Route::post('/rooms', [RoomManagementController::class, 'store'])->name('rooms.store');
        Route::put('/rooms/{room}', [RoomManagementController::class, 'update'])->name('rooms.update');

        Route::get('/bookings', [BookingManagementController::class, 'index'])->name('bookings.index');
        Route::post('/bookings', [BookingManagementController::class, 'store'])->name('bookings.store');
        Route::put('/bookings/{booking}/status', [BookingManagementController::class, 'updateStatus'])->name('bookings.update-status');

        Route::get('/checkin', [ReceptionDashboardController::class, 'checkInIndex'])->name('checkin');
        Route::post('/check-in', [ReceptionDashboardController::class, 'checkIn'])->name('check-in');
        Route::get('/checkout', [ReceptionDashboardController::class, 'checkOutIndex'])->name('checkout');
        Route::post('/checkout', [ReceptionDashboardController::class, 'checkOut'])->name('check-out');
    });

    Route::prefix('reception')->name('reception.')->middleware('role:admin,reception')->group(function () {
        Route::get('/dashboard', [ReceptionDashboardController::class, 'index'])->name('dashboard');
        Route::get('/checkin', [ReceptionDashboardController::class, 'checkInIndex'])->name('checkin');
        Route::post('/check-in', [ReceptionDashboardController::class, 'checkIn'])->name('check-in');
        Route::get('/checkout', [ReceptionDashboardController::class, 'checkOutIndex'])->name('checkout');
        Route::post('/check-out', [ReceptionDashboardController::class, 'checkOut'])->name('check-out');
        Route::get('/bookings', [ReceptionDashboardController::class, 'bookingsIndex'])->name('bookings.index');
        Route::put('/bookings/{booking}/status', [ReceptionDashboardController::class, 'updateBookingStatus'])->name('bookings.update-status');
    });
});
